<?php

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementShippingCourier
 */
class JBCartElementShippingRuspost extends JBCartElementShipping
{
    /**
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        return true;
    }
    
    public function getRate()
    {
        
        
        $city = $this->get('city');

		$orderSum = $this->_order->getTotalForItems(); // получили сумму за все товары (без доставки и прочего)

        return $this->isFree() ? $this->_order->val(0) : $this->_order->val($city);;
        
        
    }

    /**
     * @param array $params
     * @return mixed|string
     */
    public function renderSubmission($params = array())
    {
        if ($layout = $this->getLayout('submission.php')) {
            return self::renderLayout($layout, array(
                'params' => $params,
            ));
        }

        return null;
    }


    public function __construct($app, $type, $group)
        {
            parent::__construct($app, $type, $group);
            $this->registerCallback('sendPost');
        }
    
        /**
         * @return string
         */
        protected function _getAjaxLocationsUrl()
        {
            return $this->getAjaxUrl();
        }
    
    
    protected function _renderCity()
    {
       
 
        return $this->app->jbhtml->text($this->getControlName('city'), '300');
    }
    
    
    public function sendPost($To, $Weight, $Valuation) {
        
    if (empty($To)) { $To = 'Москва';}
    if (empty($Weight)) { $Weight = 1000;}
    if (empty($Valuation)) { $Valuation = 500;}

    /*
Пример обращения к API сервиса расчета почтовых тарифов Postcalc.RU.
Реализованы переключение на резервный сервер и кэширование ответов.
Кэшировать можно в любом каталоге, который доступен для записи веб-сервером.
Пример требует библиотеки php-curl.
*/

// === ИСХОДНЫЕ ДАННЫЕ
// = Данные запроса
$From = $this->config->get('citypost');
//$To = 'Новосибирск';
//$Weight = 1000;
//$Valuation = 500;
$Country = 'RU';
$Charset = 'utf-8'; // Набор символов.
$Site = $_SERVER['HTTP_HOST'];

//$Site = 'radio-safari.ru'; // Название сайта клиента
//$Email = 'admin@mysite.ru';   // Электронная почта для извещений о превышении лимита
$Email = $this->config->get('email');

// = Данные для подключения
$PostcalcServer1 = 'test.postcalc.ru';  // Рабочий сервер Postcalc.RU
$PostcalcServer2 = 'test.postcalc.ru'; // Резервное зеркало Postcalc.RU
$Timeout = 1; // При недоступности рабочего сервера переключиться на резервный через 3 сек.

// = Данные для кэширования
//$CacheDir = sys_get_temp_dir(); // Каталог для хранения кэшированных данных.
$CacheDir = 'tmp';
$CacheValid = 5; // Кэш действителен в течение 600 сек.

// === СОБСТВЕННО РАСЧЕТ 
header("Content-Type: text/html; charset=$Charset");

// Формируем строку запроса со всеми необходимыми переменными
// Функция rawurlencode обязательна, если в качестве $From и $To выступают названия населенных пунктов. 
$QueryString  = 'f='  .rawurlencode( $From );
$QueryString .= '&t=' .rawurlencode( $To );
$QueryString .= "&w=$Weight&v=$Valuation&c=RU&o=php&cs=$Charset&st=$Site&ml=$Email";

// Очищаем кэш от устарелых данных - все файлы старше $CacheValid сек.
$TimestampNow = time();
foreach ( glob("$CacheDir/postcalc_*.txt") as $CacheFile ) 
    if ( ($TimestampNow - filemtime($CacheFile) )  > $CacheValid ) unlink( $CacheFile );

// Проверяем в кэше, не было ли уже такого запроса
$CacheFile = $CacheDir. '/postcalc_' .md5($QueryString) .'.txt';

if ( file_exists( $CacheFile ) ) {
    echo "Найдено в кэше!<br>\n";
    $arrResponse = unserialize( file_get_contents($CacheFile) );
} else {
    // Инициализируем curl
    if ( function_exists('curl_init') ) {
        $curl = curl_init();
        curl_setopt_array($curl, 
            array( 
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_CONNECTTIMEOUT => $Timeout,
                CURLOPT_HTTPHEADER => array('Connection: close', 'Accept-Encoding: gzip'),
                CURLOPT_USERAGENT => phpversion()
            )
        );
    } else {
        die("Не установлен пакет php-curl!");
    }
    
    // Соединяемся с рабочим сервером
    curl_setopt($curl, CURLOPT_URL, "http://$PostcalcServer1/?$QueryString");
    $Response = curl_exec($curl);
    if ( !$Response = curl_exec($curl) ) {
       // Если по какой-то причине рабочий сервер недоступен, переходим на резервное зеркало
       curl_setopt($curl, CURLOPT_URL, "http://$PostcalcServer2/?$QueryString");
       if ( !$Response = curl_exec($curl) ) {
           die("Не удалось соединиться с $PostcalcServer1 и $PostcalcServer2 в течение $Timeout сек.!");
       }    
    }
    curl_close($curl);
    
    // Разархивируем ответ
    if ( substr($Response,0,3) == "\x1f\x8b\x08" )  $Response=gzinflate(substr($Response,10,-8));
    
    // Переводим ответ в массив PHP
    $arrResponse = unserialize($Response);
    
    // Обработка ошибки
    if ( $arrResponse['Status'] != 'OK' ) die("Сервер вернул ошибку: $arrResponse[Status]!");

    // Если ошибки не было, сохраняем ответ в кэше
    file_put_contents($CacheFile, $Response);

}

// === ВЫВОД РЕЗУЛЬТАТОВ

// Выводим значение тарифа для бандероли
$mes = 'Тариф на EMS: '.$From .' -> ' .$To .' составляет '.$arrResponse['Отправления']['EMS']['Тариф'].' руб.';
$summ = $arrResponse['Отправления']['EMS']['Тариф'];


        
                $json = array();
                //$mes = "Успешно!!!!";
                $json['ok'] = $mes; 
                $json['summ'] = $summ;
    		    echo json_encode($json); // вывoдим мaссив oтвeтa 
    		    die(); // умирaeм
            
        }

















}
